<?php
/**
 *
 * Users Email Stop. An extension for the phpBB Forum Software package.
 *
 * @copyright (c) 2025, Picaron, https://github.com/picaronin/
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace pikaron\usersemailstop;

/**
* Extension class Users Email Stop for custom enable/disable/purge actions
*/
class ext extends \phpbb\extension\base
{
	/**
	* Check whether or not the extension can be enabled.
	* The current phpBB version should meet or exceed
	* the minimum version required by this extension:
	*
	* @return bool
	* @access public
	*/
	public function is_enableable()
	{
		$config = $this->container->get('config');
		$lang = $this->container->get('language');
		$lang->add_lang('usersemailstop', 'pikaron/usersemailstop');


        /**
         * Check phpBB requirements
         *
         * Requires phpBB 3.3.0 or greater
         *
         * @return bool
         */
        // Display a custom warning message if requirement fails.
        if (!phpbb_version_compare($config['version'], '3.3.0', '>='))
        {
            // Suppress the error in case of CLI usage
            @trigger_error($lang->lang('PHPBB_INSTALL_ERROR'), E_USER_WARNING);
        }

        /**
         * Check PHP requirements
         *
         * Requires PHP 7.4.20 or greater
         *
         * @return bool
         */
        // Display a custom warning message if requirement fails.
        if (!phpbb_version_compare(PHP_VERSION, '7.4.20', '>='))
        {
            // Suppress the error in case of CLI usage
            @trigger_error($lang->lang('PHP_INSTALL_ERROR'), E_USER_WARNING);
        }

		return true;
	}
}
