<?php
/**
 *
 * Users Email Stop. An extension for the phpBB Forum Software package.
 *
 * @copyright (c) 2025, Picaron, https://github.com/picaronin/
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace pikaron\usersemailstop\migrations;

class usersemailstop_3_3_0 extends \phpbb\db\migration\migration
{
    public function effectively_installed()
    {
        return !empty($this->config['usersemailstop_version']);
    }	
	
	static public function depends_on()
	{
		return array('\phpbb\db\migration\data\v330\v330');
	}

	public function update_data()
	{
		return array(
			array('config.add', array('usersemailstop_version', '3.3.0')),
		);
	}

	public function update_schema()
	{
		return array(
			'add_tables'	=> array(
				$this->table_prefix . 'users_email_stop'	=> array(
					'COLUMNS'			=> array(
						'user_id'		=> array('UINT:10', null),
						'item_type'		=> array('VCHAR:165', null),
					),
				),
			),
			
			'add_columns'	=> array(
				$this->table_prefix . 'users' => array(
					'users_email_stop' => array('TINT:1', 0),
				),
			),			
		);
	}

    public function revert_data()
    {
        return array(
            array('config.remove', array('usersemailstop_version')),
        );
    }
	
	public function revert_schema()
	{
		return	array(
			'drop_tables' => array(
				$this->table_prefix . 'users_email_stop',
			),
			
			'drop_columns' => array(
				$this->table_prefix . 'users'	=> array(
					'users_email_stop',
				),
			),			
		);
	}
	
}
